/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.ConsoleTimeChangeInProgressException;
import com.ibm.hwmca.base.time.ConsoleTimeSetException;
import com.ibm.hwmca.base.time.CustConDateTimeBean;
import com.ibm.hwmca.base.time.CustConDateTimeBeanData;
import com.ibm.hwmca.base.time.ErrorIds;
import com.ibm.hwmca.base.time.MasterTimeSource;
import com.ibm.hwmca.base.time.MasterTimeSourceExistsException;
import com.ibm.hwmca.base.time.RebootRequiredException;
import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ConsoleTimeTasklet
extends HwmcaPanelTasklet
implements ProgressEndedListener,
ErrorIds {
    private static final String TRACE_MASKT = "XTODTSKT";
    private static final String TRACE_MASKF = "XTODTSKF";
    private static final String TRACE_MASKD = "XTODTSKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.time.res.CustDateTimeRes";
    private static final String PANEL_NAME = "CustConDateTimePanel";
    private boolean progressDismissed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "Handling initial request");
            CustConDateTimeBean bean = new CustConDateTimeBean(this.createBeanDataForCurrentTime());
            Trace.trace(TRACE_MASKF, "About to request display of initial panel with bean=" + bean);
            response.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "Termination request; about to call terminate()");
            response.terminate();
        } else {
            String command = ((TaskActionEvent)request.getData("event")).getActionCommand();
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("CANCEL")) {
                response.terminate();
            } else {
                if (command.equals("CustomizeButton")) {
                    Date newTime;
                    TimeManager tm = this.getTimeManager();
                    CustConDateTimeBeanData beanData = (CustConDateTimeBeanData)request.getData("beanData");
                    Trace.trace(TRACE_MASKF, "beanData from request=" + beanData);
                    DateFormat df = DateFormat.getDateInstance(1);
                    String date = df.format(beanData.getDateNumber().getTime());
                    DateFormat tf = DateFormat.getTimeInstance(2);
                    String time = tf.format(beanData.getTimeNumber().getTime());
                    String direction = beanData.isEastOfGreenwich() ? "+" : "-";
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setMinimumIntegerDigits(2);
                    String offsetHours = nf.format(beanData.getHoursNumber());
                    String offsetMinutes = nf.format(beanData.getMinutesNumber());
                    Trace.trace(TRACE_MASKF, "Date=" + date + "; time=" + time + "; direction=" + direction + "; offsetHours=" + offsetHours + "; offsetMinutes=" + offsetMinutes);
                    DateFormat dtf = DateFormat.getDateTimeInstance(1, 2);
                    TimeZone tz = TimeZone.getTimeZone("GMT" + direction + offsetHours + offsetMinutes);
                    dtf.setTimeZone(tz);
                    try {
                        newTime = dtf.parse(date + " " + time + " GMT" + direction + offsetHours + offsetMinutes);
                    }
                    catch (ParseException pe) {
                        Trace.trace(TRACE_MASKF, "Got a ParseException: " + pe);
                        TaskletException te = new TaskletException(pe);
                        new FrameworkLog(ErrorIds.LOGINFO, 5, te).log();
                        throw te;
                    }
                    Trace.trace(TRACE_MASKF, "newTime=" + dtf.format(newTime));
                    DateFormat f = DateFormat.getDateTimeInstance(1, 1);
                    f.setTimeZone(tz);
                    Trace.trace(TRACE_MASKF, "newTime=" + f.format(newTime));
                    Trace.trace(TRACE_MASKF, "newTime(millis)=" + newTime.getTime());
                    Calendar newTimeCalendar = Calendar.getInstance(tz);
                    newTimeCalendar.setTime(newTime);
                    BaseMessageTitle initialText = new BaseMessageTitle("TIMEPROGRESS.TITLE");
                    String id = "1";
                    PanelTaskletProgressListener progressListener = new PanelTaskletProgressListener(this);
                    ProgressStartEvent progressStartEvent = new ProgressStartEvent(this.getTask().getUIInfo().getUnlocalizedName(), new ProgressData[]{new ProgressData()}, 0L, (LocalizableText)initialText, id, (ProgressCancelListener)null, (ProgressEndedListener)this);
                    ProgressReportListenerImpl timeProgressReportListener = new ProgressReportListenerImpl(id, null, progressListener);
                    ConsoleTimeTasklet consoleTimeTasklet = this;
                    synchronized (consoleTimeTasklet) {
                        block48: {
                            this.progressDismissed = false;
                            boolean progressPanelUsed = false;
                            try {
                                progressPanelUsed = tm.requestConsoleTimeSet(newTimeCalendar, progressListener, progressStartEvent, timeProgressReportListener);
                                if (progressPanelUsed) {
                                    Trace.trace(TRACE_MASKF, "About to wait for progress panel to be dismissed");
                                    while (!this.progressDismissed) {
                                        try {
                                            this.wait();
                                        }
                                        catch (InterruptedException exc) {}
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "Time change succeeded; tell the user");
                                    this.showSuccessMessage();
                                }
                                response.update(this.createBeanDataForCurrentTime());
                            }
                            catch (ConsoleTimeChangeInProgressException ctcipe) {
                                Trace.trace(TRACE_MASKF, "There is already a console time change in progress");
                                this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                response.noAction();
                            }
                            catch (MasterTimeSourceExistsException mtsee) {
                                Trace.trace(TRACE_MASKF, "A master time source exists; find it");
                                HwmcaObject object = tm.getMasterTimeSource();
                                MasterTimeSource masterTimeSource = null;
                                if (object != null) {
                                    try {
                                        masterTimeSource = tm.getMasterTimeSourceImpl(object);
                                    }
                                    catch (HException e) {
                                        // empty catch block
                                    }
                                }
                                if (masterTimeSource != null) {
                                    this.showMasterTimeSourceMessage();
                                    if (tm.setTimeChangeInProgress(true)) {
                                        try {
                                            progressPanelUsed = tm.syncConsoleTime(object, masterTimeSource, progressListener, progressStartEvent, timeProgressReportListener, false);
                                            if (progressPanelUsed) {
                                                Trace.trace(TRACE_MASKF, "About to wait for progress panel to be dismissed");
                                                while (!this.progressDismissed) {
                                                    try {
                                                        this.wait();
                                                    }
                                                    catch (InterruptedException exc) {}
                                                }
                                            }
                                            response.update(this.createBeanDataForCurrentTime());
                                        }
                                        catch (HException he) {
                                            Trace.trace(TRACE_MASKF, "Exception on time sync:" + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            response.noAction();
                                            break block48;
                                        }
                                        finally {
                                            tm.setTimeChangeInProgress(false);
                                        }
                                    }
                                    Trace.trace(TRACE_MASKF, "Time change already in progress");
                                    this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                }
                                Trace.trace(TRACE_MASKF, "Master time source is gone before we could sync with it");
                                this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                            }
                            catch (RebootRequiredException rre) {
                                Trace.trace(TRACE_MASKF, "A reboot is required for this time change");
                                LocalizableText answer = this.showMessageBox(true, new BaseMessageTitle("TIME001.TITLE"), new BaseMessageText("TIME001.TEXT"), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                                if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                                    try {
                                        tm.setSystemTimeAndReboot(newTimeCalendar, null);
                                        response.update(this.createBeanDataForCurrentTime());
                                    }
                                    catch (HException he) {
                                        Trace.trace(TRACE_MASKF, "Exception on time set:" + he);
                                        this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                        response.noAction();
                                    }
                                } else {
                                    response.noAction();
                                }
                            }
                            catch (ConsoleTimeSetException ctse) {
                                if (ctse.isProgressPanelUsed()) {
                                    Trace.trace(TRACE_MASKF, "About to wait for progress panel to be dismissed");
                                    while (!this.progressDismissed) {
                                        try {
                                            this.wait();
                                        }
                                        catch (InterruptedException exc) {}
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "An error occurred while setting the console time: " + ctse);
                                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                }
                                response.noAction();
                            }
                            catch (HException he) {
                                Trace.trace(TRACE_MASKF, "An error occurred while setting the console time: " + he);
                                this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                response.noAction();
                            }
                        }
                    }
                }
                if (command.equals("RefreshButton")) {
                    response.update(this.createBeanDataForCurrentTime());
                } else {
                    Trace.trace(TRACE_MASKF, "Unrecognized action command: " + command);
                    new FrameworkLog(ErrorIds.LOGINFO, 4).log();
                    response.noAction();
                }
            }
        }
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(ErrorIds.LOGINFO, 2, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    protected TimeManager getTimeManager() {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.getTimeManager()");
        return TimeManager.getTimeManager();
    }

    protected void showSuccessMessage() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.showSuccessMessage()");
        this.showMessageBox(true, new BaseMessageTitle("IQZA0149.TITLE"), new BaseMessageText("IQZA0149.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
    }

    protected void showMasterTimeSourceMessage() throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> ConsoleTimeTasklet.showMasterTimeSourceMessage()");
        this.showMessageBox(true, new BaseMessageTitle("IQZA0375.TITLE"), new BaseMessageText("IQZA0375.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> progressEnded");
        ConsoleTimeTasklet consoleTimeTasklet = this;
        synchronized (consoleTimeTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- progressEnded");
    }

    private CustConDateTimeBeanData createBeanDataForCurrentTime() {
        Calendar timeCal = Calendar.getInstance();
        int offset = (timeCal.get(15) + timeCal.get(16)) / 60000;
        boolean west = offset < 0;
        offset = Math.abs(offset);
        int hours = offset / 60;
        int minutes = offset % 60;
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(timeCal.getTime());
        CustConDateTimeBeanData beanData = new CustConDateTimeBeanData(timeCal, dateCal, hours, minutes, new String[]{west ? CustConDateTimeBean.DIRECTION_CHOICE_WEST : CustConDateTimeBean.DIRECTION_CHOICE_EAST});
        Trace.trace(TRACE_MASKF, "Bean data for current time: " + beanData);
        return beanData;
    }
}

